from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrRouterLbProxyConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-lb-push-server configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_lb_push_server_loop.conf",
            ["templates/mssngr-lb-push-server.json", "templates/push_client.yml"],
            "mssngr_lb_push_server_config",
            resources.MssngrRouterLbProxyLoopConf,
            resources.MssngrRouterLbProxyConfig
        )
