from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrRouterLbSubscriberConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-lb-subscriber configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_lb_subscriber_loop.conf",
            [
                "templates/mssngr-lb-subscriber2.json",
                "templates/push_client-lbsub.yml",
                "data/tvm-ids.json",
            ],
            "mssngr_lb_subscriber2_config",
            resources.MssngrRouterLbSubscriberLoopConf,
            resources.MssngrRouterLbSubscriber2Config
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_lb_subscriber_loop.conf",
            [
                "templates/mssngr-lb-subscriber2.json",
                "data/tvm-ids.json",
            ],
            "mssngr_lb_subscriber2_config",
            resources.MssngrRouterLbSubscriberTestingLoopConf,
            resources.MssngrRouterLbSubscriber2TestingConfig
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_lb_subscriber_loop.conf",
            [
                "templates/mssngr-lb-subscriber2.json",
                "data/tvm-ids.json",
            ],
            "mssngr_lb_subscriber2_config",
            resources.MssngrRouterLbSubscriberAlphaLoopConf,
            resources.MssngrRouterLbSubscriber2AlphaConfig
        )
