from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrRouterStateCacheTools(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with tools needed for worker state cache deployment"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        pass

    def on_execute(self):
        build.build_package(
            self,
            "mssngr_state_cache_pusher",
            resources.MssngrRouterStateCachePusher,
            "mssngr/router",
            ["tools/state_cache_pusher/mssngr-state-cache-pusher"]
        )
        build.build_package(
            self,
            "mssngr_state_cache_updater",
            resources.MssngrRouterStateCacheUpdater,
            "mssngr/router",
            ["tools/state_cache_updater/mssngr-state-cache-updater"]
        )
