from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.runtime import resources
from sandbox.projects.mssngr.runtime.MssngrAutoDeployStateCache import postproc_state_cacher, release_state_cacher

from sandbox.projects.common.nanny import nanny
from sandbox import sdk2


class BuildMssngrRouterWorker(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-router and corresponding tools"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        with sdk2.parameters.RadioGroup("Sanitizer") as sanitize:
            sanitize.values["none"] = sanitize.Value(value="none", default=True)
            sanitize.values["address"] = sanitize.Value(value="address")
            sanitize.values["memory"] = sanitize.Value(value="memory")
            sanitize.values["thread"] = sanitize.Value(value="thread")
            sanitize.values["undefined"] = sanitize.Value(value="undefined")
            sanitize.values["leak"] = sanitize.Value(value="leak")

    def on_execute(self):
        build.build_daemon_package(
            self,
            resources.MssngrRouterWorker,
            "router",
            sanitize=self.Parameters.sanitize
        )
        build.build_package(
            self,
            "mssngr_state_cacher",
            resources.MssngrRouterStateCacher,
            "mssngr/router",
            ["tools/state_cacher/mssngr-state-cacher"],
            self.Parameters.sanitize
        )
        postproc_state_cacher(self)

    def on_release(self, additional_parameters):
        sdk2.Task.on_release(self, additional_parameters)
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        release_state_cacher(self, additional_parameters['release_status'])
