from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrRouterWorkerConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-router configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_router_loop.conf",
            [
                "templates/mssngr-router.json",
                "templates/moderation.json",
                "templates/common_config.json",
                "templates/push_client-worker.yml",
                "data/tvm-ids.json",
            ],
            "mssngr_router_config",
            resources.MssngrRouterWorkerLoopConf,
            resources.MssngrRouterWorkerConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_router_loop.conf",
            [
                "templates/mssngr-router.json",
                "templates/moderation.json",
                "templates/common_config.json",
                "templates/nginx.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_router_config",
            resources.MssngrRouterWorkerTestingLoopConf,
            resources.MssngrRouterWorkerTestingConfig
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_router_loop.conf",
            [
                "templates/mssngr-router.json",
                "templates/moderation.json",
                "templates/common_config.json",
                "templates/nginx.conf",
                "data/tvm-ids.json",
            ],
            "mssngr_router_config",
            resources.MssngrRouterWorkerAlphaLoopConf,
            resources.MssngrRouterWorkerAlphaConfig
        )
