from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrStickersConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-stickers configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            loop_conf_name=None,
            loopconf_resource_class=None,
            conf_file_names=["templates/mssngr-stickers.json"],
            conf_bundle_name="stickers_config",
            config_resource_class=resources.MssngrStickersConfig,
        )
        config.build_configs(
            self,
            "testing",
            loop_conf_name=None,
            loopconf_resource_class=None,
            conf_file_names=["templates/mssngr-stickers.json"],
            conf_bundle_name="stickers_config",
            config_resource_class=resources.MssngrStickersTestingConfig,
        )
        config.build_configs(
            self,
            "alpha",
            loop_conf_name=None,
            loopconf_resource_class=None,
            conf_file_names=["templates/mssngr-stickers.json"],
            conf_bundle_name="stickers_config",
            config_resource_class=resources.MssngrStickersAlphaConfig,

        )
