from sandbox.projects.mssngr.common import build
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrSupportGateway(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-support-gateway and corresponding tools"""

    class Requirements(build.CommonRequirements):
        pass

    class Parameters(build.CommonParameters):
        pass

    def on_execute(self):
        build.build_daemon_package(
            task=self,
            resource_class=resources.MssngrSupportGateway,
            daemon_name="support_gateway",
            daemon_binary_suffix="support-gateway",
            additional_subpaths=[]
        )
