from sandbox.projects.mssngr.common import config
from sandbox.projects.mssngr.runtime import resources

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class BuildMssngrSupportGatewayConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds a bundle with mssngr-support-gateway configs"""

    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(config.CommonParameters):
        pass

    def on_execute(self):
        config.build_configs(
            self,
            "production",
            "mssngr_supgw_loop.conf",
            [
                "templates/mssngr-supgw.json",
                "data/tvm-ids.json",
            ],
            "mssngr_supgw_config",
            resources.MssngrSupportGatewayLoopConf,
            resources.MssngrSupportGatewayConfig
        )
        config.build_configs(
            self,
            "alpha",
            "mssngr_supgw_loop.conf",
            [
                "templates/mssngr-supgw.json",
                "data/tvm-ids.json",
            ],
            "mssngr_supgw_config",
            resources.MssngrSupportGatewayAlphaLoopConf,
            resources.MssngrSupportGatewayAlphaConfig
        )
        config.build_configs(
            self,
            "testing",
            "mssngr_supgw_loop.conf",
            [
                "templates/mssngr-supgw.json",
                "data/tvm-ids.json",
            ],
            "mssngr_supgw_config",
            resources.MssngrSupportGatewayTestingLoopConf,
            resources.MssngrSupportGatewayTestingConfig
        )
