import os
import logging
from sandbox import sdk2
from sandbox.sandboxsdk import ssh
from sandbox.sandboxsdk import paths
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.mssngr.runtime import resources


class BuildMssngrYambCodeBundle(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        is_registry_build = sdk2.parameters.Bool(
            label="Build MSSNGR_YAMB_CODE_BUNDLE or MSSNGR_FILES_CODE_BUNDLE",
            required=True,
            default=True
        )

        git_url = sdk2.parameters.String(
            label="git_url", required=True,
            default="ssh://git@bitbucket.browser.yandex-team.ru/mssngr/messenger-backend-history.git"
        )

        git_tag = sdk2.parameters.String(label="git tag")

        vault_owner = sdk2.parameters.String(label="vault_owner", required=True, default="MSSNGR")

        vault_key = sdk2.parameters.String(
            label="vault_key", required=True, default="mssngr-r-rel__ssh_key"
        )

    def on_execute(self):
        with ssh.Key(self, self.Parameters.vault_owner, self.Parameters.vault_key):
            gitlog_path = os.path.join(paths.get_logs_folder(), 'git.log')
            with open(gitlog_path, 'a') as git_log:
                run_process(
                    ['git', 'clone', self.Parameters.git_url, self.path("repo")],
                    shell=True,
                    timeout=10000,
                    work_dir=str(self.path()),
                    stdout=git_log,
                    outputs_to_one_file=True
                )

                if not self.Parameters.git_tag:
                    git_tag = run_process(
                        ['git', 'describe', '--tags', '--abbrev=0'],
                        outs_to_pipe=True,
                        timeout=10000,
                        work_dir=str(self.path("repo"))
                    ).stdout.read().strip()
                else:
                    git_tag = self.Parameters.git_tag

                logging.info("Tag: {}".format(git_tag))

                run_process(
                    ['git', 'reset', '--hard', git_tag],
                    shell=True,
                    timeout=10000,
                    work_dir=str(self.path("repo")),
                    stdout=git_log,
                    outputs_to_one_file=True
                )

        archive_name = "repo-" + str(git_tag) + ".tar.gz"

        os.chdir(str(self.path()))
        run_process(
            ['tar', 'zcvf', self.path(archive_name), "repo"],
            shell=True,
            timeout=10000,
            log_prefix="tar"
        )

        if self.Parameters.is_registry_build:
            resources.MssngrYambCodeBundle(self, archive_name, self.path(archive_name))
        else:
            resources.MssngrFilesCodeBundle(self, archive_name, self.path(archive_name))
