# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment


class MssngrCleanupChatMembersUpdates(sdk2.Task):

    class Requirements(sdk2.Requirements):
        environments = (
            PipEnvironment("psycopg2-binary"),
        )
        cores = 1
        ram = 2048
        disk_space = 2048

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        _MIN_CLEANUP_INTERVAL = 15

        pgaas_vault_db = sdk2.parameters.String(
            "secret with pg connection string",
            default="yamb_bots_test",
        )
        cleanup_interval = sdk2.parameters.Integer(
            "cleanup interval in minutes",
            default=_MIN_CLEANUP_INTERVAL,
            required=True,
        )

    description = "Messenger: cleanup of update queues"

    def get_pgaas_connection(self):
        if self.Parameters.pgaas_vault_db:
            import psycopg2
            connection_string = str(sdk2.Vault.data(
                self.owner,
                self.Parameters.pgaas_vault_db,
            ))
            logging.debug("Connection string: %s" % connection_string)
            return psycopg2.connect(connection_string, target_session_attrs='read-write')

        return None

    def get_cleanup_interval(self):
        return max(self.Parameters._MIN_CLEANUP_INTERVAL, self.Parameters.cleanup_interval)

    def on_execute(self):
        conn = self.get_pgaas_connection()
        for table in ["chat_members_updates", "update_events"]:
            with conn.cursor() as curs:
                curs.execute("select count(*) from yamb.%s" % table)
                count = curs.fetchone()[0]
                logging.debug("OOO %s updates in table %s" % (count, table))

                curs.execute("""
                    delete from yamb.%s where timestamp < now() - INTERVAL '%d minutes'
                    RETURNING timestamp
                """ % (table, self.get_cleanup_interval()))

                deleted_count = curs.rowcount
                logging.debug("Deleted count: %s" % deleted_count)
                conn.commit()
