import numpy as np


def quant(buckets, quantiles):
    values = np.array([float(b[1]) for b in buckets])
    totalsum = np.sum(values)
    if totalsum == 0:
        for x in quantiles:
            yield None
    cs = np.cumsum(values)
    indices = np.searchsorted(cs / totalsum, quantiles)
    cs = np.insert(cs, 0, 0.0)
    for idx, q in zip(indices, quantiles):
        if idx >= len(buckets) - 1:
            yield int(buckets[-1][0])
        else:
            c = totalsum * q
            yield int((buckets[idx][0] * (cs[idx + 1] - c) + buckets[idx + 1][0] * (c - cs[idx])) / values[idx])


class BalancerStats(object):
    ammv_signals = [
        "handler_push_global_inflight_ammv",
        "handler_push_privileged_global_inflight_ammv",
        "handler_message_info_global_inflight_ammv",
        "handler_message_info_batch_global_inflight_ammv",
        "handler_history_global_inflight_ammv",
        "handler_unread_count_global_inflight_ammv",
        "handler_edit_history_global_inflight_ammv",
        "handler_subscribe_global_inflight_ammv",
        "handler_push_payload_global_inflight_ammv",
        "handler_whoami_global_inflight_ammv",
    ]

    hgram_signals = [
        "fin_history_message_processing_times_hgram",
        "fin_other_message_processing_times_hgram",
        "fin_total_processing_times_hgram",
        "postproc_block_processing_time_hgram",
        "postproc_context_processing_time_hgram",
    ]

    def __init__(self):
        pass
