import os

from sandbox import sdk2
from sandbox.projects.mssngr.zbp.common import task


class MssngrZbpBinaryBundle(sdk2.Resource):
    releasable = True
    executable = True


class MssngrUpdateZbpGraphs(task.MssngrZbpTask):

    BIN_FILE_NAME = "run_mssngr_update_zbp_graphs"

    class Parameters(task.MssngrZbpTask.Parameters):
        description = 'Update messenger zbp graphs'
        tokens = sdk2.parameters.YavSecret('Yav secret with tokens', default='sec-01ewbv0vgmmwe7kvw205kcv2xy')

    class MssngrOptions(task.MssngrZbpTask.MssngrOptions):
        bundle_resource_type = MssngrZbpBinaryBundle

    def get_env(self):
        env = dict(os.environ)
        env["ST_TOKEN"] = self.Parameters.tokens.data()['st-token']
        env["STAT_TOKEN"] = self.Parameters.tokens.data()['stat-token']
        return env
