from sandbox import sdk2

from sandbox.projects.mssngr.zbp.common.helpers import (
    RELEASE_STATUS,
    TESTING
)
from sandbox.projects.mssngr.zbp.common.parameters import DEFAULT_WAIT_SEC


class MssngrBasicTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        kill_timeout = DEFAULT_WAIT_SEC

        with sdk2.parameters.Group("Override parameters") as overrides_group:
            override_basic_params = sdk2.parameters.Bool(
                "Use custom bundle resource",
                default_value=False
            )
            with override_basic_params.value[True]:
                overridden_bundle_resource = sdk2.parameters.Resource(
                    "Bundle resource"
                    # required=True
                )

        with sdk2.parameters.Group("Task parameters") as task_params_group:
            environment = sdk2.parameters.String(
                "Environment",
                required=True,
                choices=[(x, x) for x in RELEASE_STATUS],
                default_value=TESTING
            )

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        disk_space = 1024
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass
