# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class LangDetectorSnapshot(sdk2.Resource):
    """
        Snapshot folder for LangDetector (https://tech.yandex.ru/translate/doc/dg/reference/detect-docpage/) releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class LangDetectorSnapshotUpdate(sdk2.Resource):
    """
        Snapshot folder for LangDetector (https://tech.yandex.ru/translate/doc/dg/reference/detect-docpage/) updates
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
