import distutils.dir_util

from sandbox import projects
from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.projects.common.nanny import nanny


class LangDetectorUpdateFixlists(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Update lang_detector's fixlist on production """

    class Requirements(sdk2.Requirements):
        cores = 1
        disk_space = 64  # 64 MB

    def on_release(self, params):
        nanny.ReleaseToNannyTask2.on_release(self, params)
        sdk2.Task.on_release(self, params)
        self.mark_released_resources(params['release_status'], ttl=14)

    def on_execute(self):
        # Simply reupload newest resource to sandbox, but tie it to this task.
        # Stupid, but workable.
        resource = projects.mt.lang_detector.LangDetectorSnapshotUpdate.find(
            state=ctr.State.READY,
            attrs={'released': 'stable'}
        ).first()
        resource = sdk2.ResourceData(resource)

        new_res = projects.mt.lang_detector.LangDetectorSnapshotUpdate(
            self,
            description='Reupload last resource and deliver it to Nanny/lang_detector',
            path='snapshot',
            ttl=14
        )
        new_res = sdk2.ResourceData(new_res)
        new_res.path.mkdir(parents=True, exist_ok=True)

        distutils.dir_util.copy_tree(str(resource.path), str(new_res.path))

        new_res.ready()
