import json
import logging
import os
import yaml

from sandbox import common, sdk2
from sandbox.projects.common import binary_task, task_env
from sandbox.projects.common.vcs.arc import Arc
from sandbox.projects.mt.make.util import push_arcadia_commit, apply_mtdata_updates

import sandbox.common.types.client as ctc
import sandbox.common.types.notification as ctn
import sandbox.common.types.task as ctt


class UpdateMtdata(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

        description = "Commit update to dict/mt/data.yaml file"
        owner = "MT"

        notifications = [
            sdk2.Notification(
                statuses=[
                    ctt.Status.FAILURE,
                    ctt.Status.EXCEPTION,
                    ctt.Status.TIMEOUT
                ],
                recipients=["alexeynoskov@yandex-team.ru"],
                transport=ctn.Transport.EMAIL
            )
        ]

        arcadia_branch = sdk2.parameters.String("Arcadia branch to commit changes to", required=True)
        mtdata_updates = sdk2.parameters.String("MTData updates in yaml format", required=True)

        commit_message = sdk2.parameters.String("Commit message", required=True)
        create_pr = sdk2.parameters.Bool("Whether to create PR or not", default=False)
        pr_message = sdk2.parameters.String("PR message", required=False, default=None)

        secret = sdk2.parameters.YavSecret("YAV secret identifier (with optional version)", required=True)

    class Requirements(task_env.TinyRequirements):
        pass

    def on_execute(self):
        with push_arcadia_commit(
            branch=self.Parameters.arcadia_branch,
            message=self.Parameters.commit_message,
            arc_token=self.Parameters.secret.data()['arc-token'],
            create_pr=self.Parameters.create_pr,
            pr_message=self.Parameters.pr_message
       ) as arc_root:
            apply_mtdata_updates(arc_root, self.Parameters.mtdata_updates)
