# coding=utf-8

from __future__ import absolute_import

import datetime
import distutils
import distutils.dir_util
from sandbox import projects
from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.projects.mt.util.fs as mt_fs

from sandbox.projects.common.nanny import nanny


class MakeSpellcheckerUpdateResourceParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Update build parameters"):
        exclude_ru_lm = sdk2.parameters.Bool('Exclude Russian lm update')
        exclude_uk_lm = sdk2.parameters.Bool('Exclude Ukranian lm update')
        exclude_fixlists = sdk2.parameters.Bool('Exclude fixlists update')


class MakeSpellcheckerUpdateResource(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Make spellchecker update resource from parts """

    class Requirements(sdk2.Requirements):
        cores = 1
        disk_space = 15 * 1024  # 15 GB

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(MakeSpellcheckerUpdateResourceParameters):
        pass

    def on_release(self, params):
        nanny.ReleaseToNannyTask2.on_release(self, params)
        sdk2.Task.on_release(self, params)
        # TODO(yazevnul) move `30` to a named constant and reuse it as default `ttl` for
        # spellchecker update parts and spellchecker update itself.
        self.mark_released_resources(params['release_status'], ttl=30)

    def on_execute(self):
        date = datetime.datetime.now()

        update_resource_descr = '[new_pipeline] Spellchecker update for {date:%Y-%m-%d_%H-%M-%S}'.format(date=date)
        update_resource = projects.mt.spellchecker.SpellcheckerUpdate(
            self,
            description=update_resource_descr,
            path='update',
            ttl=30, )
        update = sdk2.ResourceData(update_resource)
        update.path.mkdir(parents=True, exist_ok=True)

        if not self.Parameters.exclude_ru_lm:
            mt_fs.override_file_with_resource(
                resource_type=projects.mt.spellchecker.SpellcheckerUpdatePart,
                resource_attributes={'lang': 'ru', 'released': 'stable'},
                dst_rel_path='all/lm/word-3grams.trie',
                dst_dir=str(update.path), )

        if not self.Parameters.exclude_uk_lm:
            mt_fs.override_file_with_resource(
                resource_type=projects.mt.spellchecker.SpellcheckerUpdatePart,
                resource_attributes={'lang': 'uk', 'released': 'stable'},
                dst_rel_path='langs/uk/lm/word-3grams.trie',
                dst_dir=str(update.path), )

        if not self.Parameters.exclude_fixlists:
            fixlists_path = sdk2.ResourceData(projects.mt.spellchecker.SpellcheckerUpdatePart.find(
                state=ctr.State.READY,
                attrs={'type': 'fixlists', 'released': 'stable'}, ).first()).path
            distutils.dir_util.copy_tree(str(fixlists_path), str(update.path))

        update.ready()
