# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class MtPushClientParsers(sdk2.Resource):
    """
        Parsers for Log Broker push-client
    """
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    releasable = True
    releasers = resource_releasers.mt_releasers


class MtSnapshotData(sdk2.Resource):
    """
        Snapshot folder for DATA layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtSnapshotFast(sdk2.Resource):
    """
        Snapshot folder for FAST layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtSnapshotUpdate(sdk2.Resource):
    """
        Snapshot folder for UPDATE layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtSnapshotCustomModels(sdk2.Resource):
    """
        Snapshot folder for custom models of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtSnapshotBrowser(sdk2.Resource):
    """
        Snapshot folder for Browser Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class PbmtSnapshotData(sdk2.Resource):
    """
        Snapshot folder for PBMT DATA layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class PbmtSnapshotFast(sdk2.Resource):
    """
        Snapshot folder for PBMT FAST layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class PbmtSnapshotUpdate(sdk2.Resource):
    """
        Snapshot folder for PMBT UPDATE layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtExperimentServerExecutable(sdk2.Resource):
    """
        Executable of mt experiment server
    """
    executable = True
    releasable = True
    auto_backup = True
    releasers = resource_releasers.mt_releasers

    arcadia_build_path = 'dict/mt/make/services/experiment_server/server/server'


class MtNmtModel(sdk2.Resource):
    auto_backup = True


class MtResource(sdk2.Resource):
    auto_backup = True
