# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class MtAliceSnapshotData(sdk2.Resource):
    """
        Snapshot folder for DATA layer of Translation Scenario in Alice
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtAliceSnapshotFast(sdk2.Resource):
    """
        Snapshot folder for FAST layer of Translation Scenario in Alice
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class MtAliceSnapshotUpdate(sdk2.Resource):
    """
        Snapshot folder for UPDATE layer of Translation Scenario in Alice
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
