# coding=utf-8
from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.common.nanny import nanny


class MtYaMake(nanny.ReleaseToNannyTask2, YaMake2):
    """
    Доопределение таски YA_MAKE2 с возможностью релиза и шаблоном релиза
    """
    @property
    def release_template(self):
        return sdk2.ReleaseTemplate(
            subject='{} #{}'.format(self.Parameters.result_rt, self.id),
            message=self.Parameters.result_rd,
            types=[
                ReleaseStatus.STABLE,
                ReleaseStatus.PRESTABLE,
                ReleaseStatus.TESTING,
                ReleaseStatus.UNSTABLE,
                ReleaseStatus.CANCELLED,
            ],
        )

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        super(MtYaMake, self).on_release(additional_parameters)
