# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class MtdictSnapshot(sdk2.Resource):
    """
        Snapshot folder for Machine Translation Dictionaries releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
    release_subscribers = ['mt-dict']


class MtdictSnapshotUpdate(sdk2.Resource):
    """
        Snapshot folder with patch for MTDict instant update releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
    release_subscribers = ['mt-dict']


class MtdictCorpusSnapshot(sdk2.Resource):
    """
        Snapshot folder with patch for MTDict corpus large files
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
    release_subscribers = ['mt-dict']


class MtdictSnapshotFast(sdk2.Resource):
    """
        Snapshot folder with MTDict fast layer
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
    release_subscribers = ['mt-dict']
