# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class PredictorSnapshot(sdk2.Resource):
    """
        Snapshot folder for Predictor (https://tech.yandex.ru/predictor) releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class PredictorSnapshotFast(sdk2.Resource):
    """
        Resource for fast releases of Predictor parts (binaries & configs),
        same structure as PREDICTOR_SNAPSHOT
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
