# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class DictApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Dictionary API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class IdentityTrnslApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Identity of Y.Translate
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class LyricsTrnslApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Lyrics Translate API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class MtProductApiPortoLayer(sdk2.Resource):
    """
        Porto Layer for APIs of MT products
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class MtProductTgBotPortoLayer(sdk2.Resource):
    """
        Porto Layer for Telegram MT bot
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class MtProductWebPortoLayer(sdk2.Resource):
    """
        Porto Layer for Web interfaces of MT products
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class OcrViewerSnapshot(sdk2.Resource):
    """
        Snapshot folder for OCR Viewer
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class PdctApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Predictor API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class SearchappTrnslApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Searchapp Translate API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class SearchappTrnslApiData(sdk2.Resource):
    """
        Data folder for Searchapp Translate API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class S3MtranslateSnapshot(sdk2.Resource):
    """
        Snapshot folder for "mtranslate" S3 bucket
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = True
    readable = True
    releasers = resource_releasers.mt_product_releasers


class S3TranslateSnapshot(sdk2.Resource):
    """
        Snapshot folder for "translate" S3 bucket
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = True
    readable = True
    releasers = resource_releasers.mt_product_releasers


class S3TrbroSnapshot(sdk2.Resource):
    """
        Snapshot folder for "trbro" S3 bucket
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = True
    readable = True
    releasers = resource_releasers.mt_product_releasers


class S3YaKeyboardSnapshot(sdk2.Resource):
    """
        Snapshot folder for "ya-keyboard" S3 bucket
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = True
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TakeoutTrnslApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Takeout of Y.Translate
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TranslateMongoPortoLayer(sdk2.Resource):
    """
        Porto Layer for MongoDB of Y.Translate
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TranslateStaticPortoLayer(sdk2.Resource):
    """
        Porto Layer for static of Y.Translate
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TranslateWebSnapshot(sdk2.Resource):
    """
        Snapshot folder for Translate frontend
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TrnslApiCacheNmtPortoLayer(sdk2.Resource):
    """
        Porto Layer for Cache of Translate API (NMT)
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TrnslApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Translate API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TrnslApiStaticSnapshot(sdk2.Resource):
    """
        Snapshot folder of static for Translate API
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = True
    readable = True
    releasers = resource_releasers.mt_product_releasers


class UpdateYpHostsBinary(sdk2.Resource):
    """
        YP Hosts Update Utility
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class YaKeyboardIosAppSnapshot(sdk2.Resource):
    """
        Snapshot of iOS Keyboard App
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class YaKeyboardProxyPortoLayer(sdk2.Resource):
    """
        Porto Layer for Proxy of Y.Keyboard
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class YaKeyboardProxySnapshot(sdk2.Resource):
    """
        Snapshot folder for Proxy of Y.Keyboard
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class YaTranslateBotPortoLayer(sdk2.Resource):
    """
        Porto Layer of Y.Translate Bot
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class YaTranslateBotSnapshot(sdk2.Resource):
    """
        Snapshot folder of Y.Translate Bot
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TranslateWebLxcContainer(sdk2.service_resources.LxcContainer):
    """
    Container for translate web service tasks
    """
    releasable = True
    releasers = ['MT', 'MT_PRODUCT']
    __default_attribute__ = sdk2.parameters.String


class TranslateMlLxcContainer(sdk2.service_resources.LxcContainer):
    """
    Container for translate ML packages
    """
    releasable = True
    releasers = ['MT', 'MT_PRODUCT']
    __default_attribute__ = sdk2.parameters.String


class MtWebPythonReqs(sdk2.Resource):
    """
    Python libraries for virtualenv
    """
    releasable = False
    __default_attribute__ = sdk2.parameters.String


class MtWebNodeModules(sdk2.Resource):
    """
    node_modules cache
    """
    releasable = False
    __default_attribute__ = sdk2.parameters.String


class MtWebTestArtifact(sdk2.Resource):
    """
    MT Web test logs and results
    """
    releasable = False
    __default_attribute__ = sdk2.parameters.String


class MtMlTestArtifact(sdk2.Resource):
    """
    MT Web test logs and results
    """
    releasable = False
    __default_attribute__ = sdk2.parameters.String


class PbmtPumpkinSnapshotData(sdk2.Resource):
    """
        Snapshot folder for PBMT PUMPKIN DATA layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class PbmtPumpkinSnapshotFast(sdk2.Resource):
    """
        Snapshot folder for PBMT PUMPKIN FAST layer of Machine Translation releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class MtFfmpegBinary(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class MtFfprobeBinary(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateTranslatorBuild(sdk2.Resource):
    """
        YA_MAKE build result of video translate translator
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers

class VideoTranslateTranslatorCloudFiles(sdk2.Resource):
    """
        YA_MAKE cloud files result of video translate translator
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateDownloadServerBuild(sdk2.Resource):
    """
        YA_MAKE build result of video translate video downloader
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateDownloadServerCloudFiles(sdk2.Resource):
    """
        YA_MAKE cloud files result of video translate video downloader
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateBotBuild(sdk2.Resource):
    """
        YA_MAKE build result of video translate internal Telegram bot
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateB2bBotBuild(sdk2.Resource):
    """
        YA_MAKE build result of video translate B2B Telegram bot
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateB2bBotCloudFiles(sdk2.Resource):
    """
        YA_MAKE cloud files result of video translate B2B Telegram bot
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateBioServer(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers

class VideoTranslateBioCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateTtsServer(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateTtsModels(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateTtsCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateAsrServer(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateAsrCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateAsrLingware(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateStreamer(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateStreamerCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateStreamScheduler(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateStreamSchedulerCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateStreamFinalizer(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateStreamFinalizerCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateNeurodubApi(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateNeurodubApiCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateNeurodubAdminProxy(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateNeurodubAdminProxyCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateNeurodubTranscoder(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateNeurodubTranscoderCloudFiles(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateInfraCommon(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class MtMlTestRunner(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class VideoTranslateBqHandler(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TranslateBffSnapshot(sdk2.Resource):
    """
        Snapshot folder for Translate "backend for frontend"
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers


class TranslateApiSnapshot(sdk2.Resource):
    """
        Snapshot folder for Translate api, which released with translate frontend

    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_product_releasers
