# coding=utf-8

from __future__ import absolute_import

import sandbox.common.types.task as ctt
import datetime
from sandbox import projects
from sandbox import sdk2

from sandbox.projects.mt.make_spellchecker_update_resource import MakeSpellcheckerUpdateResourceParameters


class ReleaseSpellcheckerUpdateResourceParameters(MakeSpellcheckerUpdateResourceParameters):
    do_release = sdk2.parameters.Bool('Release created resource')
    with sdk2.parameters.String('Release status', required=True) as release_status:
        release_status.values['stable'] = 'stable'
        release_status.values['testing'] = 'testing'
        release_status.values['unstable'] = 'unstable'


class ReleaseSpellcheckerUpdateResource(sdk2.Task):
    """ Make and release spellchecker update resource from parts """

    class Requirements(sdk2.Requirements):
        disk_space = 100    # 100 MB
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(ReleaseSpellcheckerUpdateResourceParameters):
        pass

    def on_execute(self):
        with self.memoize_stage.make_task:
            make_task = projects.mt.make_spellchecker_update_resource.MakeSpellcheckerUpdateResource(
                self,
                description="Child of test task {}".format(self.id),
                notifications=self.Parameters.notifications,
                priority=ctt.Priority(
                    ctt.Priority.Class.SERVICE,
                    ctt.Priority.Subclass.HIGH, ),
                exclude_ru_lm=self.Parameters.exclude_ru_lm,
                exclude_uk_lm=self.Parameters.exclude_uk_lm,
                exclude_fixlists=self.Parameters.exclude_fixlists,
            ).enqueue()
            self.Context.make_task_id = make_task.id
            raise sdk2.WaitTask(self.Context.make_task_id, ctt.Status.Group.SUCCEED)

        if self.Parameters.do_release:
            subject = 'Automatic spellchecker update release {date:%Y-%m-%d_%H-%M-%S}'.format(
                date=datetime.datetime.now(), )
            self.server.release(
                task_id=self.Context.make_task_id,
                subject=subject,
                type=self.Parameters.release_status, )
