# coding=utf-8

from __future__ import absolute_import

import sandbox.common.types.client as ctc
import sandbox.projects.mt.util as mt_util
from sandbox import sdk2
import shlex


class MkTrieYtBinary(sdk2.Resource):
    """ mktrie-yt binary """
    executable = True


class RunMkTrieYt(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX

    class Parameters(sdk2.Task.Parameters):
        mktrie_yt_resource = sdk2.parameters.Resource(
            'mktrie-yt binary',
            resource_type=MkTrieYtBinary,
            required=True, )
        mktrie_yt_cmd = sdk2.parameters.String(
            'mktrie-yt cmd',
            required=True, )
        env_vars = sdk2.parameters.String(
            'environment variables',
            default_value='',)

    def on_execute(self):
        mktrie_yt_cmd = [
            str(sdk2.ResourceData(self.Parameters.mktrie_yt_resource).path),
        ] + shlex.split(self.Parameters.mktrie_yt_cmd) + [
            '--output', 'trie.trie', ]
        env_vars = mt_util.env.env_from_string(self.Parameters.env_vars)

        with sdk2.helpers.ProcessLog(self, logger='mktrie-yt') as mktrie_log:
            sdk2.helpers.subprocess.check_call(
                mktrie_yt_cmd,
                stdout=mktrie_log.stdout,
                stderr=mktrie_log.stderr,
                env=env_vars, )
        # TODO(yazevnul): publish resource with trie
