# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class SpellcheckerSnapshot(sdk2.Resource):
    """
        Snapshot folder for Spellchecker
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.mt_releasers


class SpellcheckerSnapshotPart(sdk2.Resource):
    """
        Part of snapshot folder for Spellchecker
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.mt_releasers


class SpellcheckerUpdate(sdk2.Resource):
    """
        Contents of update folder
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.mt_releasers
    version = sdk2.Attributes.Integer("Package version", default_value=0)


class SpellcheckerUpdatePart(sdk2.Resource):
    """
        Contents of update folder
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.mt_releasers


class SpellcheckerSatellite(sdk2.Resource):
    """
        Ops scripts and tools to accompany spellchecker binary.
    """
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    releasable = True
    releasers = resource_releasers.mt_releasers


class SpellcheckerExecutable(sdk2.Resource):
    """
        Исполняемый файл опечаточника dict/misspell/spellchecker/tools/spelld
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    executable = True
    auto_backup = True


class SpellcheckerServerConfig(sdk2.Resource):
    """
        Файл server.cfg для опечаточника dict/misspell/spellchecker/tools/spelld
    """
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True


class SpellcheckerMisspellConfig(sdk2.Resource):
    """
        Файл misspell.ini для опечаточника dict/misspell/spellchecker/tools/spelld
    """
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True


class SpellcheckerData(sdk2.Resource):
    """
        Папка с данными для запука опечаточника dict/misspell/spellchecker/tools/spelld
    """
    __default_attribute__ = sdk2.parameters.String


class SpellcheckerQueries(sdk2.Resource):
    """
        Queries for spellchecker
        (http://yandextank.readthedocs.io/en/latest/tutorial.html#uri-post-style)
    """
    __default_attribute__ = sdk2.parameters.String


class SpellcheckerQueriesResult(sdk2.Resource):
    """
        Results for spellchecker queries
        (json row per query)
    """
    __default_attribute__ = sdk2.parameters.String


class SpellcheckerToy(sdk2.Resource):
    """
        Toy resource. Use when you write task and you want to release resource
        but don't wont it to interfere with any of processes that use them.
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    releasable = True
    releasers = resource_releasers.mt_releasers


class SpellcheckerLogsDirectory(sdk2.Resource):
    """
        Logs directory for spellchecker
    """
    __default_attribute__ = sdk2.parameters.String

    share = False
