# encoding=utf-8

from __future__ import absolute_import

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class SpellerSnapshot(sdk2.Resource):
    """
        Snapshot folder for Speller (https://tech.yandex.ru/speller) releases
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class SpellerSnapshotData(sdk2.Resource):
    """
        Resource for slow releases of Speller parts (data),
        same structure as SPELLER_SNAPSHOT
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers


class SpellerSnapshotFast(sdk2.Resource):
    """
        Resource for fast releases of Speller parts (binaries & configs),
        same structure as SPELLER_SNAPSHOT
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    auto_backup = True
    any_arch = False
    readable = True
    releasers = resource_releasers.mt_releasers
