import os

from sandbox import sdk2
from sandbox.projects.common.vcs.arc import Arc, ArcCommandFailed

ARC_MOUNT_MAX_ATTEMPTS = 5


class ArcMixin(object):
    class ArcParams(sdk2.Parameters):
        commit = sdk2.parameters.String('Arc commit', required=True)
        arcadia_path = sdk2.parameters.String('Arc path', default_value='dict/mt/web')

    def init_arc(self, task):
        self.work_dir = os.getcwd()
        self.__task = task

        self.repo_path = os.path.join(self.work_dir, 'arc')

    def mount_arc(self, fetch_all=False):
        self.arc = Arc(secret_name='ARC_TOKEN', secret_owner='MT')
        self.mount_arc_internal(self.arc, fetch_all=fetch_all)

    def unmount_arc(self):
        if hasattr(self, 'mount_point') and self.mount_point.mounted:
            self.mount_point.unmount()

    def mount_arc_internal(self, arc, attempt=0, fetch_all=True):
        try:
            self.mount_point = arc.mount_path(
                None, changeset=self.__task.Parameters.commit,
                mount_point=self.repo_path,
                fetch_all=fetch_all
            )
        except ArcCommandFailed as e:
            if attempt < ARC_MOUNT_MAX_ATTEMPTS:
                self.mount_arc_internal(arc, attempt + 1, fetch_all=fetch_all)
            else:
                raise e
