# encoding=utf-8

from __future__ import absolute_import

import re
from sandbox import sdk2
import shlex
import tempfile


_VAULT_RE = re.compile(r'\$\(vault:(?P<dst>file|value):(?P<owner>[^:]+):(?P<name>[^:]+)\)')


def resolve_vault_templates(s):
    def deref(match):
        secret = sdk2.Vault.data(match.group('owner'), match.group('name'))

        if match.group('dst') == 'file':
            path = tempfile.NamedTemporaryFile().name
            with open(path, 'wb') as out:
                out.write(secret)
            return path

        return secret

    return _VAULT_RE.sub(deref, s)


def env_from_string(s):
    return {k: resolve_vault_templates(v) for k, v in (e.split('=') for e in shlex.split(s))}
