# coding: utf-8

import abc

import sandbox.common.types.misc as ctm
import sandbox.sdk2 as sdk2


class MusicBCDBaseTask(sdk2.Task):
    """Dummy task for testing purposes"""

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 2 * 60

    @classmethod
    def __subclasshook__(cls, subclass):
        return (hasattr(subclass, 'build') and
                callable(subclass.build) and
                hasattr(subclass, 'deploy') and
                callable(subclass.deploy) or
                NotImplemented)

    @abc.abstractmethod
    def build(self):
        raise NotImplementedError

    @abc.abstractmethod
    def deploy(self):
        raise NotImplementedError

    def on_execute(self):
        self.build()
        self.deploy()
