import logging

import sandbox.sdk2 as sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask


class MusicBinaryTaskTemplate(binary_task.LastBinaryTaskRelease, MusicBaseTask):
    """Template task for music binary sandbox tasks"""

    class Requirements(sdk2.Requirements):
        # configure this for your task, the more accurate - the better
        cores = 2

    class Parameters(sdk2.Task.Parameters):
        description = "Template task"

        some_value = "Some value"

        yav_secret = sdk2.parameters.YavSecret("Some yav secret identifier", required=True,
                                               default="sec-01e48pq47t03vs1gft6fj7xsd0")
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        from sandbox.projects.music.MusicBinaryTaskTemplate.py3_source.SomeCode import SomeClass

        super(MusicBinaryTaskTemplate, self).on_execute()

        cl = SomeClass()
        out = cl.say_blah()
        logging.info("I said: \"{}\"".format(out))

        logging.info("Task ran. Task value = {}".format(self.Parameters.some_value))
