import logging

log = logging.getLogger(__name__)


class SomeClass:
    def __init__(self):
        log.info("I am initializing")
        self.blah = "blah"

    def say_blah(self):
        log.info("I am running some code")
        # Using f-string to make sure the class is py3 only
        return f"I say {self.blah}"


if __name__ == '__main__':
    import sys

    logging.basicConfig(stream=sys.stdout, level=logging.DEBUG)

    cl = SomeClass()
    log.info(f"I said: \"{cl.say_blah()}\"")
