import logging
import os

from Buildable import DOWNLOAD_DIR, BUILD_DIR, TARGET_DIR
from Sources import SOURCES


class BuildStaticFFtools:
    def __init__(self, set_info, task_id):
        self.log = logging.getLogger(self.__class__.__name__)
        self.set_info = set_info
        self.task_id = task_id

        self.prepare_directories()
        self.download_all()
        self.build_all()

    def prepare_directories(self):
        for name in [DOWNLOAD_DIR, BUILD_DIR, TARGET_DIR]:
            try:
                os.makedirs(name)
            except OSError:
                pass

    def download_all(self):
        self.set_info('Downloading and extracting all sources')
        for source in SOURCES:
            source.download()
            source.extract()

    def build_all(self):
        self.set_info('Building all sources')
        for source in SOURCES:
            source.build(self.set_info, self.task_id)
