import platform

from Buildable import Buildable, OpenSSLBuildable, X265Buildable, ReconfBuildable, CmakeBuildable, \
    AutogenBuildable, FfmpegBuildable, Patch, VorbisBuildable, TheoraBuildable, ZimgBuildable, AssBuildable

static_args = [] if platform.system() == 'Darwin' else [
    '--pkg-config-flags=--static',
    '--extra-ldexeflags=-static',
]

ffmpeg_configure_args = [
    '--extra-cflags=-I/home/paulus/ffmpeg-ext/target/include',
    '--extra-ldflags=-L/home/paulus/ffmpeg-ext/target/lib',
    '--extra-libs=-lpthread -lm -lz -ldl',
    '--enable-pic',
    '--enable-ffplay',
    '--enable-fontconfig',
    '--enable-frei0r',
    '--enable-gpl',
    '--enable-version3',
    '--enable-libass',
    '--enable-libfribidi',
    '--enable-libfdk-aac',
    '--enable-libfreetype',
    '--enable-libmp3lame',
    '--enable-libopencore-amrnb',
    '--enable-libopencore-amrwb',
    '--enable-libopenjpeg',
    '--enable-libopus',
    '--enable-libsoxr',
    '--enable-libspeex',
    '--enable-libtheora',
    '--enable-libvidstab',
    '--enable-libvo-amrwbenc',
    '--enable-libvorbis',
    '--enable-libvpx',
    '--enable-libwebp',
    '--enable-libx264',
    '--enable-libx265',
    '--enable-libxvid',
    '--enable-libzimg',
    '--enable-nonfree',
    '--enable-openssl',
]

SOURCES = [
    Buildable(name='yasm',
              url='http://www.tortall.net/projects/yasm/releases/yasm-1.3.0.tar.gz',
              md5='fc9e586751ff789b34b1f21d572d96af'),
    Buildable(name='nasm',
              url='https://www.nasm.us/pub/nasm/releasebuilds/2.15.05/nasm-2.15.05.tar.bz2',
              md5='b8985eddf3a6b08fc246c14f5889147c'),
    OpenSSLBuildable(name='openssl',
                     url='https://github.com/openssl/openssl/archive/refs/tags/OpenSSL_1_1_1k.tar.gz',
                     md5='bdd51a68ad74618dd2519da8e0bcc759'),
    Buildable(name='cmake',
              url='https://github.com/Kitware/CMake/releases/download/v3.20.2/cmake-3.20.2.tar.gz',
              md5='cd0e7735f1e51f30ee3b0844390a464a',
              configure_args=['--parallel=10']),
    Buildable(name='libpng',
              url='https://download.sourceforge.net/libpng/libpng-1.6.37.tar.xz',
              md5='015e8e15db1eecde5f2eb9eb5b6e59e9'),
    Buildable(name='zlib',
              url='https://github.com/madler/zlib/archive/refs/tags/v1.2.11.tar.gz',
              md5='0095d2d2d1f3442ce1318336637b695f',
              file='zlib-v1.2.11.tar.gz',
              configure_args=[]),
    Buildable(name='x264',
              url='https://code.videolan.org/videolan/x264/-/archive/stable/x264-stable.tar.gz',
              md5=None,
              configure_args=['--enable-static', '--disable-shared', '--disable-opencl', '--enable-pic']),
    X265Buildable(name='x265',
                  url='https://bitbucket.org/multicoreware/x265_git/downloads/x265_3.5.tar.gz',
                  md5='deb5df5cb2ec17bdbae6ac6bbc3b1eef'),
    ReconfBuildable(name='fdk-aac',
                    url='https://github.com/mstorsjo/fdk-aac/archive/refs/tags/v2.0.2.tar.gz',
                    md5='b15f56aebd0b4cfe8532b24ccfd8d11e',
                    file='fdk-aac-2.0.2.tar.gz'),
    AutogenBuildable(name='harfbuzz',
                     url='https://github.com/harfbuzz/harfbuzz/archive/refs/tags/4.2.1.tar.gz',
                     md5='f7ffb38200b549a1f3cac39958472846',
                     file='harfbuzz-4.2.1.tar.gz'),
    Buildable(name='fribidi',
              url='https://github.com/fribidi/fribidi/releases/download/v1.0.10/fribidi-1.0.10.tar.xz',
              md5='97c87da9930e8e70fbfc8e2bcd031554',
              configure_args=['--disable-docs', '--disable-shared', '--enable-static']),
    AssBuildable(name='libass',
                 url='https://github.com/libass/libass/releases/download/0.15.1/libass-0.15.1.tar.xz',
                 md5='65e60f7bb7e881b453bede1faad10b77'),
    Buildable(name='lame',
              url='https://sourceforge.net/projects/lame/files/lame/3.100/lame-3.100.tar.gz',
              md5='83e260acbe4389b54fe08e0bdbf7cddb',
              configure_args=['--enable-nasm', '--disable-shared', '--enable-static']),
    AutogenBuildable(name='flac',
                     url='https://github.com/xiph/flac/archive/refs/tags/1.3.4.tar.gz',
                     md5='f08d7794091d9074a18c2c19ad993a39',
                     file='flac-1.3.4.tar.gz'),
    Buildable(name='libopusenc',
              url='https://archive.mozilla.org/pub/opus/libopusenc-0.2.1.tar.gz',
              md5='f038ea0f4168d184c76b42d293697c57'),
    Buildable(name='opus-1',
              url='https://archive.mozilla.org/pub/opus/opus-1.3.1.tar.gz',
              md5='d7c07db796d21c9cf1861e0c2b0c0617'),
    Buildable(name='opusfile',
              url='https://downloads.xiph.org/releases/opus/opusfile-0.12.tar.gz',
              md5='45e8c62f6cd413395223c82f06bfa8ec'),
    AutogenBuildable(name='opus-tools',
                     url='https://github.com/riarheos/opus-tools/archive/refs/heads/master.tar.gz',
                     md5='7cb73f4ed0182de90fd4fe991bde097b',
                     file='opus-tools-0.2.tar.gz'),
    Buildable(name='libvpx',
              url='https://github.com/webmproject/libvpx/archive/refs/tags/v1.10.0.tar.gz',
              md5='cded283be38dc0078c3fbe751722efc5',
              file='vpx-1.10.0.tar.gz',
              configure_args=['--disable-examples', '--disable-unit-tests', '--enable-pic']),
    CmakeBuildable(name='soxr',
                   url='https://sourceforge.net/projects/soxr/files/soxr-0.1.3-Source.tar.xz',
                   md5='3f16f4dcb35b471682d4321eda6f6c08',
                   cmake_args=['-DBUILD_SHARED_LIBS:bool=off', '-DWITH_OPENMP:BOOL=OFF', '-DBUILD_TESTS:bool=off']),
    CmakeBuildable(name='vid.stab',
                   url='https://github.com/georgmartius/vid.stab/archive/refs/tags/v1.1.0.tar.gz',
                   md5='633af54b7e2fd5734265ac7488ac263a',
                   file='vidstab-1.1.0.tar.gz',
                   cmake_args=['-DBUILD_SHARED_LIBS:BOOL=OFF', '-DUSE_OMP:BOOL=OFF']),
    ZimgBuildable(name='zimg',
                  url='https://github.com/sekrit-twc/zimg/archive/release-3.0.4.tar.gz',
                  md5='9ef18426caecf049d3078732411a9802',
                  file='zimg-3.0.4.tar.gz'),
    CmakeBuildable(name='openjpeg',
                   url='https://github.com/uclouvain/openjpeg/archive/refs/tags/v2.4.0.tar.gz',
                   md5='4d388298335947367e91f1d100468af1',
                   file='openjpeg-2.4.0.tar.gz',
                   cmake_args=['-DBUILD_SHARED_LIBS:BOOL=OFF']),
    AutogenBuildable(name='libwebp',
                     url='https://github.com/webmproject/libwebp/archive/refs/tags/v1.2.0.tar.gz',
                     md5='d0df15b4235d024652841f2f926f72b4',
                     file='webp-0.6.1.tar.gz'),
    VorbisBuildable(name='libvorbis',
                    url='https://github.com/xiph/vorbis/releases/download/v1.3.7/libvorbis-1.3.7.tar.xz',
                    md5='50902641d358135f06a8392e61c9ac77'),
    Buildable(name='libogg',
              url='https://github.com/xiph/ogg/releases/download/v1.3.4/libogg-1.3.4.tar.xz',
              md5='eadef24aad6e3e8379ba0d14971fd64a'),
    TheoraBuildable(name='libtheora',
                    url='http://downloads.xiph.org/releases/theora/libtheora-1.1.1.tar.bz2',
                    md5='292ab65cedd5021d6b7ddd117e07cd8e'),
    ReconfBuildable(name='vo-amrwbenc',
                    url='https://github.com/mstorsjo/vo-amrwbenc/archive/refs/tags/v0.1.3.tar.gz',
                    md5='f1e835858de9571749612c4c163341e1',
                    file='vo-amrwbenc-0.1.3.tar.gz'),
    AutogenBuildable(name='speex',
                     url='https://github.com/xiph/speex/archive/Speex-1.2.0.tar.gz',
                     md5='4bec86331abef56129f9d1c994823f03'),
    Patch(name='FFmpeg',
          url='https://paste.yandex-team.ru/4386373/text',
          md5='d992885fec7a2ba5487d2247061fee95',
          file='ff.patch'),
    FfmpegBuildable(name='FFmpeg',
                    url='https://github.com/FFmpeg/FFmpeg/archive/refs/tags/n5.0.1.tar.gz',
                    md5='c3204047453ba07aaba44b743d057269',
                    file='ffmpeg-5.0.1.tar.gz',
                    configure_args=ffmpeg_configure_args + static_args),
]
