import os
import shutil

import sandbox.common.types.misc as ctm
import sandbox.sdk2 as sdk2

from BuildStaticFFtools import BuildStaticFFtools
from Buildable import DOWNLOAD_DIR


class MusicFftoolsResource(sdk2.Resource):
    """ Ffmpeg suite tools """
    pass


class MusicFftoolsSources(sdk2.Resource):
    """ Ffmpeg suite sources """
    pass


class MusicBuildFftools(sdk2.Task):
    """ Build a static fftools resource for music transcoding """

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        container_resource = 2171564886

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 30 * 60
        description = "Build static tools for music transcoding"
        sources = sdk2.parameters.Resource('Sources', resource_type=MusicFftoolsSources, required=True)

    def on_execute(self):
        sources_path = str(sdk2.ResourceData(self.Parameters.sources).path)
        os.symlink(sources_path, DOWNLOAD_DIR)

        BuildStaticFFtools(self.set_info, str(self.id))

        res = MusicFftoolsResource(self, "Fftools resource", "fftools")
        data = sdk2.ResourceData(res)

        data.path.mkdir(0o755)
        shutil.copy('build-target/bin/ffmpeg', 'fftools/ffmpeg')
        shutil.copy('build-target/bin/ffprobe', 'fftools/ffprobe')
        shutil.copy('build-target/bin/lame', 'fftools/lame')
        shutil.copy('build-target/bin/opusmenc', 'fftools/opusmenc')
        shutil.copytree(sources_path + '/qaac', 'fftools/qaac')
        data.ready()
