# coding=utf-8
import sandbox.common.types.task
import sandbox.projects.common.task_env as te
import sandbox.sdk2 as sdk2
from sandbox.common import errors
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper


class MusicDiffTest(sdk2.Task, TaskHelper):
    class Requirements(te.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):

        kill_timeout = 10 * 60
        description = "Diff test task"

        host1 = sdk2.parameters.String('Host1 for diff test')
        host2 = sdk2.parameters.String('Host2 for diff test', default='https://api.music.qable.yandex.net')
        issue = sdk2.parameters.String("Startrek issue to inform to", required=False)
        secret_tokens = sdk2.parameters.YavSecret(
            "YAV secret test secrets",
            default='sec-01f49h7he3yen9sn23gpm9jb8n',
            required=True,
            description="Yav secrets to unpack during tests"
        )

        abc_token = sdk2.parameters.YavSecret("ABC OAuth token secret", required=True,
                                              description="Yav secret with ABC token",
                                              default='sec-01fp7s63sd8dgjga0erprk7tfx')
        abc_token_key = sdk2.parameters.String("Key for abc token in yav secret", required=True,
                                               default="abc_token")

        autorelease_binary = sdk2.parameters.Bool(
            "Build sandbox binary task from trunk",
            required=True,
            default=False
        )

    def bind_latest_binary(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            owner="MUSIC",
            attrs={"task_type": "MUSIC_DIFF_TEST"},
        ).first()

    def on_enqueue(self):
        if not self.Requirements.tasks_resource:
            if not self.Parameters.autorelease_binary or self.Context.built:
                self.bind_latest_binary()

    def check_binary(self):
        if not self.Requirements.tasks_resource:
            if self.Parameters.autorelease_binary and not self.Context.built:
                self.Context.built = True
                from sandbox.projects.sandbox.deploy_binary_task import DeployBinaryTask
                raise sdk2.WaitTask(
                    tasks=[self.enqueue_subtask(DeployBinaryTask,
                                                target='sandbox/projects/music/MusicDiffTest/py3',
                                                description='Autoreleasing for MUSIC_DIFF_TEST',
                                                attrs={'task_type': 'MUSIC_DIFF_TEST'}
                                                )],
                    statuses=sandbox.common.types.task.Status.SUCCESS
                )
        if not self.Requirements.tasks_resource:
            raise RuntimeError('Task binary not found')

    def on_execute(self):
        self.check_binary()

        from sandbox.projects.music.MusicDiffTest.lib.main import run
        from sandbox.projects.music.deployment.helpers.AbcHelper import AbcHelper
        from sandbox.projects.music.deployment.helpers.Config import CONFIG
        from sandbox.projects.music.deployment.helpers.StartrekHelper import StartrekHelper
        from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper

        token = sdk2.Vault.data(CONFIG.token)
        st = StartrekHelper(token)
        test_results = run(self)
        report_url = test_results['report_url']
        if test_results['Error'] != 0 or test_results['Diff'] != 0:
            if self.Parameters.issue:
                abc_token = self.Parameters.abc_token.data()[self.Parameters.abc_token_key]
                th = TaskHelper()
                th.abc_helper = AbcHelper(abc_token)
                st.add_comment(self.Parameters.issue,
                               u'Тест api diff !!сломался!!:\n'
                               u'((https://sandbox.yandex-team.ru/task/{0} {0}))\n'
                               u'Test report: (({1} test_report.html))'
                               .format(self.id, report_url),
                               summonee=th.backend_on_duty())
            raise errors.TaskFailure()
        else:
            if self.Parameters.issue:
                st.add_comment(self.Parameters.issue,
                               u'Тест api diff прошёл успешно:\n'
                               u'Sandbox task: ((https://sandbox.yandex-team.ru/task/{0} {0}))\n'
                               u'Test report: (({1} test_report.html))'
                               .format(self.id, report_url))
                st.patch_release_issue_statuses_raw(self.Parameters.issue, CONFIG.monitored_deployment_test_names,
                                                    self.__class__.__name__)
