import sandbox.sdk2
from sandbox.projects.music.MusicDiffTest.lib.models.AppConfigurator import AppConfigurator
from sandbox.projects.music.MusicDiffTest.lib.reports import report_generator
from sandbox.projects.music.MusicDiffTest.lib.services.TestRunnerService import TestRunnerService


def run(task: sandbox.projects.music.MusicDiffTest.MusicDiffTest):
    host1 = 'https://api.music.qa.yandex.net'
    host2 = 'https://api.music.qable.yandex.net'
    component = 'music-web'

    application = AppConfigurator(host1, host2)
    test_run_carcas = application.persister.prepare_test_run_data()
    test_run = application.persister.prepare_test_run(
        task,
        test_run_carcas,
        component,
        application.host1,
        application.host2
    )
    test_run.host1 = host1
    test_run.host2 = host2
    test_runner = TestRunnerService(test_run, True)
    test_runner.launch_test_run()
    return report_generator(task, test_runner.test_run)
