import json
import logging
from collections import defaultdict

import sandbox.sdk2
from library.python import resource
from sandbox.projects.music.MusicDiffTest.lib.models.TestCase import TestCase
from sandbox.projects.music.MusicDiffTest.lib.models.TestController import TestController
from sandbox.projects.music.MusicDiffTest.lib.models.TestRun import TestRun
from sandbox.projects.music.MusicDiffTest.lib.models.TestStep import TestStep


class ArcadiaResourcePersister():
    PRESETS_FOLDER = 'sandbox/projects/music/MusicDiffTest/lib/presets'

    def prepare_test_run_data(self):

        test_run_carcas = defaultdict()

        logging.info(f'Looking for keys in folder {self.PRESETS_FOLDER}')
        for key in resource.iterkeys(self.PRESETS_FOLDER):
            logging.info(f'Found key: {key}')
            stripped = key[len(self.PRESETS_FOLDER):]
            component = stripped.split('/')[1]
            controller = stripped.split('/')[2]
            if component not in test_run_carcas:
                test_run_carcas[component] = {}
            if controller not in test_run_carcas[component]:
                test_run_carcas[component][controller] = []

            test_run_carcas[component][controller].append(key)
        return test_run_carcas

    def prepare_test_run(self, task: sandbox.projects.music.MusicDiffTest.MusicDiffTest, test_run_carcas, component,
                         host1, host2):
        test_run = TestRun(component)
        for controller in test_run_carcas[component]:
            if test_run_carcas[component][controller]:
                test_controllers = TestController(component, controller)
                test_case_id = 0
                for test_case_path in test_run_carcas[component][controller]:
                    test_case_structure = json.loads(resource.find(test_case_path).decode('utf-8'))
                    users = test_case_structure['users'] if 'users' in test_case_structure else None
                    test_case = self._test_case_factory(test_case_id,
                                                        task,
                                                        test_case_structure,
                                                        host1, host2,
                                                        users)
                    test_case_id += 1
                    test_controllers.add_test_case(test_case)
                test_run.test_controllers.append(test_controllers)
        return test_run

    @staticmethod
    def _test_case_factory(id,
                           task: sandbox.projects.music.MusicDiffTest.MusicDiffTest,
                           test_case_structure,
                           host1, host2, users):
        from sandbox.projects.music.MusicDiffTest.lib.utils.helpers import resolve_music_host_tepmlate
        test_case = TestCase(id, test_case_structure['test_case'],
                             test_case_structure['description'],
                             users)
        for step in test_case_structure['steps']:
            request = step.get('request')
            order = step.get('order')
            name = step.get('name')
            host_template = step.get('host_template')
            if host_template:
                host1 = resolve_music_host_tepmlate(host1, host_template)
                host2 = resolve_music_host_tepmlate(host2, host_template)
            ignore_paths = step.get('ignore_paths').split(',') \
                if step.get('ignore_paths') else None
            if request:
                method = request.get('method')
                url = request.get('url')
                query_params = request.get('query_params')
                headers = request.get('headers')
                oauth_token_secret_name = step.get('oauth_token')
                if oauth_token_secret_name:
                    token = task.Parameters.secret_tokens.data()[oauth_token_secret_name]
                    headers['Authorization'] = f'OAuth {token}'
                body = request.get('body')
                expected_status_codes = request.get('expected_status_codes')
                extract = request.get('extract')
                test_step = TestStep(order, name, host1, host2, method, url,
                                     query_params, headers, body,
                                     expected_status_codes, extract,
                                     ignore_paths)
                test_case.test_steps.append(test_step)
        return test_case
