def get_report_header(report_title):
    return '<div style="display: flex; justify-content:space-between">' \
           '<h2 style="display: inline;">{} Report</h2>{}</div><hr>' \
        .format(report_title, get_legend())


def get_preset_header(preset, statistics):
    all = '<span><span class="legend-el"><span style="width: 1em;height:' \
          ' 1em;background-color: silver;display: inline-block;"">' \
          '</span> - {}</span>'.format(statistics["OK"]
                                       + statistics["Diff"]
                                       + statistics["Error"])
    ok = '<span class="legend-el"><span style="width: 1em;height:' \
         ' 1em;background-color: green;display: inline-block;"">' \
         '</span> - {}</span>'.format(statistics["OK"])
    diff = '<span class="legend-el"><span style="width: 1em;height:' \
           ' 1em;background-color: yellow;display: inline-block;"">' \
           '</span> - {}</span>'.format(statistics["Diff"])
    error = '<span class="legend-el"><span style="width: 1em;height:' \
            ' 1em;background-color: red;display: inline-block;"">' \
            '</span> - {}</span></span>'.format(statistics["Error"])

    return '<div><h2>{}</h2>{}{}{}{}<br></div>'.format(preset.strip(),
                                                       all, ok,
                                                       diff, error)


def get_legend():
    return """
    <span>
      <span class="legend-el">
        <span
          style="
            width: 1em;
            height: 1em;
            background-color: green;
            display: inline-block;
          "
        >
        </span>
        - OK
      </span>
      <span class="legend-el">
        <span
          style="
            width: 1em;
            height: 1em;
            background-color: yellow;
            display: inline-block;
          "
        >
        </span>
        - DIFF
      </span>
      <span class="legend-el">
        <span
          style="
            width: 1em;
            height: 1em;
            background-color: red;
            display: inline-block;
          "
        >
        </span>
        - PRESET/NETWORK/HOST ERROR
      </span>
    </span>
    """


def get_overall_statistics(statistics):
    head = """
        <table
      border="1"
      cellpadding="5"
      style="width: 90%; margin: auto;"
      style="border-collapse: collapse; border: 1px solid black;"
    >
      <tr>
        <th style="background-color: silver;">ALL</th>
        <th style="background-color: green;">OK</th>
        <th style="background-color: yellow;">DIFF</th>
        <th style="background-color: red;">ERROR</th>
      </tr>
      <tr>
      """
    td_element = '<td style="width: 25%; text-align: center;">{}</td>'
    all = td_element.format(statistics["ALL"])
    ok = td_element.format(statistics["OK"])
    diff = td_element.format(statistics["Diff"])
    error = td_element.format(statistics["Error"])
    tail = '</tr></table><hr>'
    return head + all + ok + diff + error + tail


def get_diff_report(test_case, title):
    return '<tr><td>{}</td><td class="status-code">{}</td><td class="diff"><details><pre>{}</pre></details></td></tr>' \
        .format(
        test_case["name"] + '<br>' + test_case["method"] + '<br><details>' +
        '<div class="diff borders">' + test_case["curl1"] + '</div><br>' + '<div class="diff borders">' + test_case[
            "curl2"] +
        '</div><br></details>',
        str(test_case["status_code1"]) + '/' + str(test_case["status_code2"]),
        test_case["reason"])


def get_no_diff_report(test_case, title):
    return '<tr><td>{}</td><td class="status-code">{}</td><td class="diff">NO DIFF</td></tr>' \
        .format(
        test_case["name"] + '<br>' + test_case["method"] + '<br><details>' +
        '<div class="diff borders">' + test_case["curl1"] + '</div><br>' + '<div class="diff borders">' + test_case[
            "curl2"] +
        '</div><br></details>',
        str(test_case["status_code1"]) + '/' + str(test_case["status_code2"]))


def get_error_report(test_case, title):
    return '<tr><td>{}</td><td class="status-code"></td><td class="diff">{}</td></tr>' \
        .format(test_case["name"] + '<br><details>' +
                '<div class="diff borders">' + test_case["curl1"] + '</div><br>' + '<div class="diff borders">' +
                test_case[
                    "curl2"] +
                '</div><br></details>', test_case["reason"])


def report_test_case(test_case, index):
    status = test_case["results"][int(index)]["status"]
    if status == 'Aborted':
        return status, get_error_report(test_case["results"][index], test_case["test_case"])
    elif status == 'Nodiff':
        return status, get_no_diff_report(test_case["results"][index], test_case["test_case"])
    else:
        return status, get_diff_report(test_case["results"][index], test_case["test_case"])


def report_generator(task, test_run):
    test_run_stats = {
        "OK": 0,
        "Error": 0,
        "Diff": 0
    }
    from library.python import resource

    report_data_head = resource.find('sandbox/projects/music/MusicDiffTest/lib/templates/report_header.html').decode(
        'utf-8')
    import os
    os.makedirs('checks')
    with open(r'checks/test_run_report.html', 'w') as report:
        report_data = ''
        test_run_title = test_run.title
        test_run = test_run.get_results()

        for test_controller in test_run:
            test_controller_stats = {
                "OK": 0,
                "Error": 0,
                "Diff": 0
            }
            report_data_ctrl_body = '<div><table>'
            for test_case in test_run[test_controller]:
                test_case_statuses = set()
                test_case_status_color = 'green'
                child_report_part = '<tr><td><details><table>'

                for i in range(len(test_case["results"])):
                    status, test_step_report = report_test_case(test_case, i)
                    test_case_statuses.add(status)
                    child_report_part += test_step_report
                child_report_part += '</table></details></tr></td>'
                if "Aborted" in test_case_statuses:
                    test_case_status_color = 'red'
                    test_controller_stats["Error"] += 1
                    test_run_stats["Error"] += 1
                elif "Diff" in test_case_statuses:
                    test_case_status_color = 'yellow'
                    test_controller_stats["Diff"] += 1
                    test_run_stats["Diff"] += 1
                else:
                    test_controller_stats["OK"] += 1
                    test_run_stats["OK"] += 1
                report_data_ctrl_body += '<tr><td style="background-color: {};"><h3>{}</h3></td></tr>' \
                    .format(test_case_status_color, test_case["test_case"])
                report_data_ctrl_body += child_report_part
            report_data_ctrl_body += '</table></div><hr>'
            report_data_ctrl_header = get_preset_header(test_controller, test_controller_stats)
            report_data += report_data_ctrl_header + report_data_ctrl_body
        report_data += '</body></html>'
        test_run_stats["ALL"] = test_run_stats.get("OK") + test_run_stats.get("Diff") + test_run_stats["Error"]
        report_data_header = get_report_header(test_run_title) + get_overall_statistics(test_run_stats)

        data_report = ""

        for statistics_result in test_run_stats:
            data_report += statistics_result + ": " + str(test_run_stats[statistics_result]) + "\n"

        full_report = report_data_head + report_data_header + report_data
        report.write(full_report)

    from sandbox.projects.music.resources import MusicApiDiffResource
    from sandbox import sdk2

    resource = MusicApiDiffResource(
        task,
        description='Music api diff resource',
        path='checks',
        ttl=14
    )
    data = sdk2.ResourceData(resource)
    data.ready()

    report_url = resource.http_proxy + '/test_run_report.html'
    task.set_info(info='Diff report: <a href="{}">test_run_report.html</a>'.format(report_url), do_escape=False)
    test_run_stats['report_url'] = report_url
    return test_run_stats
