import json
import re

from sandbox.projects.music.MusicDiffTest.lib.models.TestStep import TestStep
from sandbox.projects.music.MusicDiffTest.lib.utils.helpers import headers_injection


class InjectionService:
    AUTH_REGEXP = r'\$.+?##.+?\$'
    DEPS_FIELDS = ['url', 'query_params', 'body', 'headers']
    DEPENDENCY_REGEXP = r'<[a-z]+>'

    @staticmethod
    def insert_auth(test_step: TestStep, users: dict):
        step_headers1 = test_step.request1.get("headers")
        step_headers2 = test_step.request2.get("headers")
        values_to_replace = re.findall(
            InjectionService.AUTH_REGEXP,
            step_headers1
        )

        if len(values_to_replace) > 0:
            step_headers1 = json.dumps(
                headers_injection(step_headers1, values_to_replace, users))
            step_headers2 = json.dumps(
                headers_injection(step_headers2, values_to_replace, users))
        test_step.request1['headers'] = step_headers1
        test_step.request2['headers'] = step_headers2
        return test_step

    @staticmethod
    def insert_dependencies(test_step: TestStep, shared_data: dict):
        for field in InjectionService.DEPS_FIELDS:
            step_field1 = test_step.request1.get(field)
            step_field2 = test_step.request2.get(field)

            if step_field1 and step_field2:
                found = re.findall(
                    InjectionService.DEPENDENCY_REGEXP,
                    step_field1
                )

                if found:
                    for value in found:
                        repl_data1 = shared_data.get("host1").get(
                            value.strip('<>')
                        )
                        repl_data2 = shared_data.get("host2").get(
                            value.strip('<>')
                        )

                        old_data1 = test_step.request1[field]
                        old_data2 = test_step.request2[field]
                        test_step.request1[field] = re.sub(
                            value,
                            str(repl_data1),
                            old_data1
                        )

                        test_step.request2[field] = re.sub(
                            value,
                            str(repl_data2),
                            old_data2
                        )
        return test_step

    @staticmethod
    def extract_shared_data(response1: str, response2: str, headers1, headers2,
                            fields_to_extract, shared_data: dict):

        if not fields_to_extract:
            return

        extract_from_headers = fields_to_extract.get('headers')
        extract_from_body = fields_to_extract.get('body')
        if extract_from_headers:
            for field in extract_from_headers:
                shared_data["host1"][field] = headers1.get(field)
                shared_data["host2"][field] = headers2.get(field)
        if extract_from_body:
            for field in extract_from_body:
                if field.startswith('x_text'):
                    field = field.split('#')[1]
                    shared_data["host1"][field] = response1
                    shared_data["host2"][field] = response2
                else:
                    shared_data["host1"][field] = response1[field]
                    shared_data["host2"][field] = response2[field]
        return shared_data
