import json
import re

from sandbox.projects.music.MusicDiffTest.lib.models.TestStep import TestStep


def host_resolver(host):
    if not (host.startswith('http://') or host.startswith('https://')):
        raise ValueError("Host is in wrong format")
    return host


def resolve_music_host_tepmlate(host, template):
    if 'pr-' in host and 'qa' in host:
        pr_number = re.findall('pr-(\d+)', host)
        if template == 'internal':
            return f'http://web-pr-{pr_number}.music.qa.yandex.net'
        elif template == 'external':
            return f'https://api-pr-{pr_number}.music.qa.yandex.net'
        else:
            raise Exception('Unknown template for pr')
    elif 'qable' in host:
        if template == 'internal':
            return 'http://music-web.music.qable.yandex.net/internal-api/'
        elif template == 'external':
            return 'https://api.music.qable.yandex.net'
        else:
            raise Exception('Unknown template for qable')
    elif 'qa' in host:
        if template == 'internal':
            return 'http://music-web.music.qa.yandex.net/internal-api/'
        elif template == 'external':
            return 'https://api.music.qa.yandex.net'
        else:
            raise Exception('Unknown template for qa')
    raise Exception('Unknown host template')


def test_step_url_preparator(test_step):
    query_params1 = test_step.request1.get("query_params")
    query_params2 = test_step.request2.get("query_params")

    query_params1 = query_params1 if query_params1 else ''
    query_params2 = query_params2 if query_params2 else ''

    url1 = test_step.request1.get('url') + query_params1
    url2 = test_step.request2.get('url') + query_params2

    return (test_step.request1.get('host') + url1,
            test_step.request2.get('host') + url2)


def curl_generator(request_url1, request_url2, test_step: TestStep):
    base_curl = 'curl --location --request ' + test_step.request1.get('method')

    url1 = ' \'{}\' '.format(request_url1)
    url2 = ' \'{}\' '.format(request_url2)

    headers1 = json.loads(test_step.request1.get('headers'))
    headers2 = json.loads(test_step.request2.get('headers'))

    curl_headers1 = ""
    if headers1:
        for header in headers1:
            curl_headers1 += f'--header \'{header}:{headers1[header]}\' '
    curl_headers2 = ""
    if headers2:
        for header in headers2:
            curl_headers2 += f'--header \'{header}:{headers2[header]}\' '

    body1 = test_step.request1.get('body').replace('\\n', '')
    body2 = test_step.request2.get('body').replace('\\n', '')

    if body1 != 'null':
        body1 = '--data-raw \'{}\''.format(body1)
    else:
        body1 = ''
    if body2 != 'null':
        body2 = '--data-raw \'{}\''.format(body2)
    else:
        body2 = ''
    return (base_curl + url1 + curl_headers1 + body1,
            base_curl + url2 + curl_headers2 + body2)


def headers_injection(headers, values_to_replace, users):
    headers = json.loads(headers)
    for value_to_replace in values_to_replace:
        for header in headers:
            if value_to_replace in headers[header]:
                user_arr = value_to_replace.strip("$").split('##')
                user = user_arr[0]
                auth_type = user_arr[1]
                headers[header] = users.get(user).get(auth_type)
                break
    return headers


def get_preset_ignore():
    with open('.presetignore', 'r') as f:
        data = [line.strip() for line in f.readlines()]
    return data
