import logging
from collections import defaultdict
from datetime import datetime

import requests

from sandbox.projects.music.MusicDutyCallsReporter.py3_source.Juggler import LogRecord

log = logging.getLogger(__name__)


def _sanitize_str(s: str):
    return s.lower().replace("-", "_").replace(".", "_")


class Solomon:
    api = "https://solomon.yandex.net/api/v2"

    def __init__(self, token: str, project: str, cluster: str, service: str):
        self.token = token
        self.project = project
        self.cluster = cluster
        self.service = service
        self.session = self.prep_session()

    def prep_session(self):
        s = requests.Session()
        s.headers["Authorization"] = f"OAuth {self.token}"
        return s

    def push_metrics(self, calls: list[LogRecord]):
        url = f"{self.api}/push"
        metric = defaultdict(lambda: defaultdict(lambda: defaultdict(int)))

        for call in calls:
            metric[call.time.date()]["login"][call.login] += 1
            metric[call.time.date()]["juggler_service"][call.service] += 1
            metric[call.time.date()]["call_status"][call.status] += 1
            metric[call.time.date()]["juggler_project"][call.project] += 1

        data = {
            "metrics": [
            ]
        }

        for day in metric:
            for tag in metric[day]:
                for val in metric[day][tag]:
                    data["metrics"].append(
                        {
                            "labels""": {
                                tag: val
                            },
                            "value": metric[day][tag][val],
                            "ts": datetime.combine(day, datetime.max.time()).strftime("%Y-%m-%dT%H:%M:%SZ")
                        }
                    )
                    # print(f"{tag}.{val}: {metric[day][tag][val]}")

            # print(datetime.combine(day, datetime.max.time()).
            #       strftime("%Y-%m-%dT%H:%M:%SZ"))
            # print(len(metric[day]))

        from pprint import pprint as pp
        pp(data)
        params = {
            "project": self.project,
            "cluster": self.cluster,
            "service": self.service
        }

        req = requests.Request("POST", url=url, json=data, params=params, headers={
            "Content-Type": "application/json"
        })
        prepped = self.session.prepare_request(req)
        try:
            log.info("Sending metrics to solomon")
            res = self.session.send(prepped, verify=False)
            res.raise_for_status()
        except:
            log.exception("Something went wrong", exc_info=True)
            log.error(res.json())
            raise
        log.info(res.json())
