import logging
import os

from sandbox.projects.music.MusicDutyCallsReporter.py3_source.Juggler import Juggler
from sandbox.projects.music.MusicDutyCallsReporter.py3_source.Solomon import Solomon

log = logging.getLogger(__name__)


class PlotJugglerCallInSolomon:
    def __init__(self, juggler_oauth, solomon_oauth, solomon_project, solomon_cluster, solomon_service):
        self.juggler_oauth = juggler_oauth
        self.solomon_oauth = solomon_oauth
        self.solomon_cluster = solomon_cluster
        self.solomon_project = solomon_project
        self.solomon_service = solomon_service

    def run(self, projects: list, days_ago: int):
        jg = Juggler(self.juggler_oauth)
        calls = jg.get_escalations_log(projects, days_ago)
        log.debug("Got following calls: {}".format(calls))
        solomon = Solomon(self.solomon_oauth, self.solomon_project, self.solomon_cluster, self.solomon_service)
        solomon.push_metrics(calls)


if __name__ == '__main__':
    import logging
    import sys

    logging.basicConfig(stream=sys.stdout, level=logging.DEBUG)

    solomon_token = os.getenv("SOLOMON_TOKEN")
    juggler_token = os.getenv("JUGGLER_TOKEN")
    assert juggler_token and solomon_token

    juggler_reporter = PlotJugglerCallInSolomon(juggler_token,
                                                solomon_token,
                                                solomon_project="music",
                                                solomon_cluster="juggler",
                                                solomon_service="calls_test")
    juggler_reporter.run(["music.infra", "music.backend", "music"], 20)
