from sandbox import sdk2

from sandbox.projects.common import binary_task
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask


class MusicDutyCallsReporter(binary_task.LastBinaryTaskRelease, MusicBaseTask):
    class Parameters(sdk2.Task.Parameters):
        description = "Gather info on duty calls and plot it in solomon"

        ext_params = binary_task.binary_release_parameters(stable=True)

        kill_timeout = 10 * 60

        juggler_token = sdk2.parameters.YavSecret("Juggler OAuth token secret", required=True,
                                                  description="Yav secret with Juggler token",
                                                  default='sec-01d56bxh7ks9t2950jzq0bhvc2')
        juggler_token_key = sdk2.parameters.String("Key for juggler token in yav secret",
                                                   required=True,
                                                   default="juggler_oauth")

        solomon_token = sdk2.parameters.YavSecret("Solomon OAuth token secret", required=True,
                                                  description="Yav secret with ABC token",
                                                  default='sec-01d56bxh7ks9t2950jzq0bhvc2')
        solomon_token_key = sdk2.parameters.String("Key for solomon token in yav secret",
                                                   required=True,
                                                   default="solomon_oauth")

    def on_execute(self):
        from sandbox.projects.music.MusicDutyCallsReporter.py3_source.main import PlotJugglerCallInSolomon

        super(MusicDutyCallsReporter, self).on_execute()

        juggler_token = self.Parameters.juggler_token.data()[self.Parameters.juggler_token_key]
        solomon_token = self.Parameters.solomon_token.data()[self.Parameters.solomon_token_key]

        juggler_reporter = PlotJugglerCallInSolomon(juggler_token,
                                                    solomon_token,
                                                    solomon_project="music",
                                                    solomon_cluster="juggler",
                                                    solomon_service="juggler_calls")
        juggler_reporter.run(["music.infra", "music.backend", "music"], 10)
