import sandbox.sdk2 as sdk2

from Processor import Processor, QueryStatus

CFG = """
percentile:
  - 0.90
  - 0.95
  - 1.00

events:
  - targetName:     trackMb
    eventMapper:    Storage_usage
    extractMapper:  trackMb
    reducer:        percentile

  - targetName:     trackCount
    eventMapper:    Storage_usage
    extractMapper:  trackCount
    reducer:        percentile

  - targetName:     otherUsersTrackMb
    eventMapper:    Storage_usage
    extractMapper:  otherUsersTrackMb
    reducer:        percentile

  - targetName:     avgTrackSize
    eventMapper:    Storage_usage
    extractMapper:  trackMb / trackCount
    reducer:        percentile

  - targetName:     wantPlayTrack
    eventMapper:    WANT_PLAY_TRACK
    reducer:        count

  - targetName:     trackIsPlaying
    eventMapper:    TRACK_IS_PLAYING
    reducer:        count

  - targetName:     failedStarts
    eventMapper:    WANT_PLAY_TRACK - TRACK_IS_PLAYING
    reducer:        count

  - targetName:     errorPrepare
    eventMapper:    TRACK_ERROR_PREPARE
    reducer:        count

  - targetName:     errorLoad
    eventMapper:    TRACK_ERROR_LOAD
    reducer:        count

  - targetName:     errorPrefetch
    eventMapper:    TRACK_ERROR_PRE_FETCH
    reducer:        count

  - targetName:     errorFallbackMds
    eventMapper:    TRACK_ERROR_FALLBACK_MDS
    reducer:        count
"""


class MusicProcessMobileGraphs(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        cores = 1

    def on_execute(self):
        token = sdk2.Vault.data("ROBOT_MUSIC_BACKEND_MOBILE_GRAPHS_TOKEN")

        with self.memoize_stage.start():
            mgp = Processor(CFG, token, False)
            self.Context.query_id = mgp.start_processing_logs()
            raise sdk2.WaitTime(360)

        mgp = Processor(CFG, token, True)
        status = mgp.query_status(self.Context.query_id)
        if status == QueryStatus.RUNNING:
            raise sdk2.WaitTime(120)

        if status != QueryStatus.COMPLETED:
            raise RuntimeError('Expected the YQL query %s to be COMPLETED' % self.Context.query_id)

        mgp.finalize_processing_logs(self.Context.query_id)
