# coding: utf-8
import logging
from textwrap import dedent

from sandbox import sdk2
from sandbox.common import errors
from sandbox.common.types.task import Status
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask


class MusicBuildBasePortoLayer(MusicBaseTask):
    class Parameters(sdk2.Task.Parameters):
        description = "Build Base Porto Layer untop of the Base search ubuntu porto layer"

    def create_subtask(self):
        logging.info("Create BUILD_PORTO_LAYER subtask")
        task_class = sdk2.Task["BUILD_PORTO_LAYER"]
        sub_task = task_class(
            self,
            description="Build Base Music Porto layer",

            layer_name="music-base-bionic-layer",
            layer_type="PORTO_LAYER_MUSIC_BASE_BIONIC",
            parent_layer_type="PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP",
            script=dedent("""
                arcadia:/robots/trunk/genconf/PORTOVM/common/apt-update.sh
                arcadia:/arc/trunk/arcadia/music/bootstrap/porto_layers/base.sh
                arcadia:/robots/trunk/genconf/PORTOVM/common/cleanup.sh
            """),

            memory_limit="1024",
            space_limit="2048",
            start_os=True,
            compress="tar.zst",
            merge_layers=True,
        )
        sub_task.enqueue()
        self.Context.subtask = sub_task.id
        self.Context.save()
        raise sdk2.WaitTask(sub_task.id, Status.Group.FINISH + Status.Group.BREAK)

    def check_subtask(self):
        logging.info("Checking subtask status")
        sub_tasks = sdk2.Task.find(id=self.Context.subtask).limit(1)
        sub_task = list(sub_tasks)[0]

        if sub_task.status == Status.SUCCESS:
            self.set_info(info="Build success", do_escape=False)
            return
        raise errors.TaskFailure()

    def on_execute(self):
        with self.memoize_stage.create_subtask:
            # will run only once
            self.create_subtask()

        self.check_subtask()
