# coding: utf-8

from sandbox.projects.common import link_builder as lb
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.Nyan import nyan
from sandbox.projects.music.resources import MusicBcdResource


class MusicBuildBcd(YaMakeTemplate.YaMakeTemplate):
    class Parameters(YaMakeTemplate.get_project_params([MusicBcdResource])):
        description = "Build Music BCD"

    def on_break(self, prev_status, status):
        message = "Sandbox task [{task_name}]({link}) failed\n".format(task_name=str(self.type),
                                                                       link=lb.task_link(self.id, plain=True))
        nyan(message, chat_id=CONFIG.stepanar_tg_chat)
