import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm
import sandbox.sdk2 as sdk2
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2

from sandbox.projects.music.deployment.MusicBuildOpusenc.Builder import build_opusenc


class MusicOpusencResource(sdk2.Resource):
    """ Opusenc """
    releasable = True


class MusicBuildOpusenc(ReleaseToNannyTask2, sdk2.Task):
    """ Build Opusenc """

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        client_tags = ctc.Tag.LINUX_PRECISE     # actually trusty, but precises have internet access

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 2 * 60
        description = "Build Opusenc"
        fail_on_any_error = True

    def on_execute(self):
        result_path = build_opusenc()

        resource = MusicOpusencResource(self, "Opusenc resource", result_path)
        data = sdk2.ResourceData(resource)
        data.ready()

        self.set_info('Successfully built the resource')
