import os
import shutil

import sandbox.projects.common.arcadia.sdk as asdk
import sandbox.sdk2 as sdk2
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2

from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask


class MusicSolomonMRResource(sdk2.Resource):
    """ Music Solomon MR code """
    releasable = True


class MusicBuildSolomonMR(ReleaseToNannyTask2, MusicBaseTask):
    """ Build Music Solomon MR """
    fail_on_any_error = True

    class Requirements(sdk2.Task.Requirements):
        disk_space = 75 * 1024

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 25 * 60
        description = "Build Yandex.Music SolomonMR"

        url = sdk2.parameters.String("The arcadia url",
                                     default=CONFIG.arcadia_trunk,
                                     required=True)

    def on_execute(self):
        with asdk.mount_arc_path(self.Parameters.url) as path:
            asdk.do_build(build_system=asdk.consts.YMAKE_BUILD_SYSTEM,
                          source_root=path,
                          targets=['admins/solomon-mr'],
                          results_dir='build',
                          clear_build=False)

        os.mkdir('out')
        shutil.copyfile('build/admins/solomon-mr/daemon/solomon-mr-daemon', 'out/solomon-mr-daemon')
        shutil.copyfile('build/admins/solomon-mr/recalculate/solomon-mr-recalculate', 'out/solomon-mr-recalculate')

        res = MusicSolomonMRResource(self,
                                     description='Music Solomon MR Resource',
                                     path='out',
                                     ttl=7)
        data = sdk2.ResourceData(res)
        data.ready()
