# coding: utf-8

import sandbox.sdk2 as sdk2
from sandbox.common import errors

from sandbox.projects.music.deployment.helpers.Config import CONFIG
from sandbox.projects.music.deployment.helpers.Deployment import Deployment
from sandbox.projects.music.deployment.helpers.TaskHelper import TaskHelper
from sandbox.projects.music.deployment.helpers.MusicBaseTask import MusicBaseTask


class MusicCheckRevisionIsGreen(MusicBaseTask, TaskHelper):
    """ Checks if the specified revision is green in CI """

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60  # real run time ~ 1min
        revision = sdk2.parameters.Integer("Revision to be checked in ci.yandex-team.ru", required=True)
        branch = sdk2.parameters.String("The branch name", required=True)

        with sdk2.parameters.Output():
            broken_tests = sdk2.parameters.Integer("The failed test count")

    def on_execute(self):
        self.check_authorization(self.author, CONFIG.token, CONFIG.auth_build)

        self.Parameters.broken_tests = Deployment().get_revision_fail_count(self.Parameters.revision,
                                                                            self.Parameters.branch)

        if self.Parameters.broken_tests is None:
            raise errors.TaskFailure("Revision {}/{} not found in CI".format(self.Parameters.branch,
                                                                             self.Parameters.revision))

        if self.Parameters.broken_tests:
            raise errors.TaskFailure("Revision {}/{} has {} broken test(s)".format(self.Parameters.branch,
                                                                                   self.Parameters.revision,
                                                                                   self.Parameters.broken_tests))
